%{
#define input getch
#define unput ungetch
#define PACK(x, y)  ((x << 16) | y)
#include "y.tab.h"
#include "dcon.h"
%}
%%
%{
int c;
char *p, *q;
%}
"\\\n"			;
"\n"			return('\n');
[ \t]			;
"/*"[^\n]* {
	yylval = calloc(yyleng-1, 1);
	strcpy(yylval, yytext+2);
	return(COMMENT);
	}

"/"[abhwl][doxcv] {
	yylval = PACK(yytext[1], yytext[2]);
	return(PRINTOP);
	}

"/"[abhwl] {
	yylval = PACK(yytext[1], 0);
	return(PRINTOP);
	}

"/"[doxcsiv] {
	yylval = PACK(0, yytext[1]);
	return(PRINTOP);
	}

"/e"[bhwl]"c" {
	yylval = PACK(yytext[2], 'c');
	xlate = 1;
	return(PRINTOP);
	}

"/ec" {
	yylval = PACK(1, 'c');
	xlate = 1;
	return(PRINTOP);
	}

"/ix" {
	yylval = PACK(0, 'j');
	return(PRINTOP);
	}

"//"			return(DIVIDE);
"/"			{ yylval = 0; return(PRINTOP); }
".."			return(DOTDOT);
"~="			return(NE);
"=="			return(EQ);
"<="			return(LE);
">="			return(GE);
"&&"			return(AND);
"||"			return(OR);
;r[0-9]+ {
	if ((yylval = tobinary(yytext+2, 10)) > 15){
		error(0, "Illegal register");
		gobble();
		return(LEXERR);
		}
	return(REG);
	}

;fr[0246] {
	yylval = yytext[3]-'0';
	return(FLTREG);
	}

;psw		return(PPSW);
;r		return(PREG);
;bp		return(BRKP);
";go"[^\n]* {
	yylval = calloc(yyleng-2, 1);
	strcpy(yylval, yytext+3);
	return(GO);
	}

;cont		return(CONT);
;ss		return(SS);
;save           return(SAVE);
;rst            return(RST);
;quit		return(0);
;brks		return(BREAKS);
;clr		return(CLEAR);
;if		return(IF);
";out"[^\n]* {
	for (p = yytext+4; *p == ' ' || *p == '\t'; p++);
	if (*p != '\0') {
		yylval = calloc(yyleng-(p-yytext)+1, 1);
		strcpy(yylval, p);
		}
	else yylval = 0;
	return(REDIR);
	}
";do"[^\n]* {
	for (p = yytext+3; *p == ' ' || *p == '\t'; p++);
	if (*p != '\0') {
		yylval = calloc(yyleng-(p-yytext)+1, 1);
		strcpy(yylval, p);
		}
	else yylval = 0;
	return(DO);
	}
";copy"[^\n]* {
	for (p = yytext+5; *p == ' ' || *p == '\t'; p++);
	if (*p != '\0') {
		yylval = calloc(yyleng-(p-yytext)+1, 1);
		strcpy(yylval, p);
		}
	else yylval = 0;
	return(COPY);
	}
";macro"        return(MACRO);
[cxfhbi]"'"[A-Za-z0-9?]+"'" {
	yylval = yytext[0];
	p = yytext + 2;
	if (strlen(p) > MAXPATTERN)             /* > cuz of ending quote*/
		error(0, "pattern too long");
	for (p=yytext+2 ; *p != '\'' ; p++);
	*p = '\0';
	strcpy(pattern, yytext+2);
	return(PATTERN);
	}
"enter("	return(ENTER);
"exit("         return(EXIT);
[A-Za-z0-9_$@][A-Za-z0-9_#$@]* {
	switch(yytext[0]){
		case '0':
			if (yytext[1] == 'x') yylval = tobinary(yytext+2,16);
			else yylval = tobinary(yytext+1,8);
			break;
		case '1': case '2': case '3': case '4': case '5':
		case '6': case '7': case '8': case '9':
			yylval = tobinary(yytext,10);
			break;
		case '$':
			if (yytext[1] == '\0') return('$');
		default:
			if ((yylval = lookup(yytext)) != NULL)
				return(SYMBOL);
			if (argsflag) {
				yylval = calloc(yyleng, 1);
				strcpy(yylval, yytext);
				return(SYMBOL);         /* found arg    */
				}
			else {
				error(0, "symbol not found");
				gobble();
				return(LEXERR);
				}
		}
	if (yylval == -1) return(LEXERR);
	return(NUMBER);
	}
"#"[A-Za-z0-9_#$@]+ {
	if ((yylval=lookup(yytext)) != NULL)
		return(DSYMBOL);
	else {
		yylval = insert(yytext);
		return(DSYMBOL);
		}
	}
"#"[A-Za-z0-9_#$@]+"["[0-9]+"]" {
	for (p=yytext; *p!='\0' && *p != '[' ; p++);
	if ( *p != '[' )
		error(0, "array syntax error");
	*p = '\0';                              /* yytext now just var  */
	p++;

	for (q=p; *q >= '0' && *q <= '9'; q++);
	if ( *q != ']' )
		error(0, "array syntax error");
	*q = '\0';

	dim = tobinary(p, 10);

	if ((yylval=lookup(yytext)) != NULL)
		return(DSYMBOL);
	else {
		yylval = insert(yytext);
		decl = 1;
		return(DSYMBOL);
		}
	}

[A-Za-z0-9_#$@]+":"[A-Za-z0-9_#$@]+   {
	if ((yylval = lookuplocal(yytext)) != NULL)
		return(LSYMBOL);
	error(0, "symbol not found");
	gobble();
	return(LEXERR);
	}
![^\n]* {
	yylval = calloc(yyleng, 1);
	strcpy(yylval, yytext+1);
	return(SYSTEM);
	}
.		return(yytext[0]);
%%
tobinary(st, b)
char *st;
register int b;{

	register int n, c;
	register char *s;
	int t;

	n = 0;
	s = st;
	while (c = *s++){
		if (c >= '0' && c <= '9') t = c-'0';
		else if (b == 16 && c >= 'a' && c <= 'f') t = c-'a'+10;
		else if (b == 16 && c >= 'A' && c <= 'F') t = c-'A'+10;
		else {
			error(0, "Illegal number");
			if (!inpattern) gobble();
			return(-1);
			}
		if (t >= b) {
			error(0, "Illegal number");
			if (!inpattern) gobble();
			return(-1);
			}
		n = n*b+t;
		}
	return(n);
	}

static char pushbuf[BUFSIZ];
static char *bufp = pushbuf;

getch(){

	register int c;

	if (bufp > pushbuf) return(*--bufp);
	if ((c = getc(in)) == EOF)
		if (popin()==0) return(0);
			else return( getch() );
	return(c);
	}

ungetch(c)
register int c;{

	if (bufp >= pushbuf+BUFSIZ)
		error(1, "Buffer overflow");
	*bufp++ = c;
	}

gobble(){

	register int c;

	while ((c = input()) != '\n' && c != EOF);
	unput('\n');
	}
