/*
 *  This routine scans the inode-blocks for filesystem disks and
 *  counts the number of blocks each user has allocated.
 */
#include <sys/param.h>
#include <sys/ino.h>
#include <sys/filsys.h>
#include <pwd.h>
#include <stdio.h>

#define MAXUSERS 256
#define MAXDEPTS 10000
#define BSIZEW BSIZE/sizeof(int)
#define NINODE INOPB*16
 
struct filsys sblock;
struct dinode  inode[NINODE];

int blocks[MAXUSERS];
int totblks;
int totinod;
int dept[MAXDEPTS];

struct {
        char    m_name[32];
        char    m_dev[32];
} mentry;

int     fi;
int     nifiles;
int     aflg;
int     tflg;
int     sflg;
int     mflg;
int     dflg;
 

main(argc, argv)
char **argv;
{
        int i;
 
        while(--argc > 0 && *argv[1]=='-') {
                argv++;
                while(*++*argv) switch(**argv) {
                        case 'a':
                                aflg++;
                                continue;
                        case 't':
                                tflg++;
                                continue;
                        case 's':
                                sflg++;
                                continue;
                        case 'd':
                                dflg++;
                                continue;
                        case 'm':
                                mflg++;
                                continue;
                        default:
                                printf("usage: disku [-adtsm] [filesys ...]\n");
                                exit(1);
                }
        }
        argv++;

        if(argc <= 0) {
                chdir("/dev");
                i = open("/etc/mtab", 0);
                while(read(i, &mentry, sizeof (mentry)) == sizeof (mentry)) {
                        if(mentry.m_dev[0] == 0) continue;
                        if (!mflg)
                                printf("/dev/%s:\n", mentry.m_dev);
                        du(mentry.m_dev);
                }
        } else
                for(i=0; i<argc; i++) {
                        if (!mflg && argc>1)
                                printf("%s:\n", argv[i]);
                        du(argv[i]);
                }
        if (sflg)
		output();
}
 

du(file)
char *file;
{
        int i, j, uid, ino;
 
        fi = open(file, 0);
        if (fi < 0) {
                printf("Cannot open %s\n", file);
                return;
        }
        sync();
        bread(1, &sblock, BSIZE);
        nifiles =  (sblock.s_isize - 2) * INOPB;
        totblks += sblock.s_fsize;
        totinod += sblock.s_isize - 2;
        ino = 0;
        for (i = 0; ino < nifiles; i += NINODE/INOPB) {
                bread(i+2, inode, sizeof inode);
                for (j=0; j < NINODE && ino < nifiles; j++) {
                        ino++;
                        uid = inode[j].di_uid;
                        if (uid < 0 || uid > MAXUSERS - 1)
				uid = 0;
                        if (inode[j].di_size > 0)
                                blocks[uid] += filesize(&inode[j]);
                }
        }
        close(fi);
        if (!sflg) {
                output();
                for(i=0; i<MAXUSERS; i++)
                        blocks[i] = 0;
                for(i=0; i<MAXDEPTS; i++)
                        dept[i] = 0;
                totblks = totinod = 0;
        }
}

filesize(ip)
struct dinode *ip;
{
	register int i, j;
        register int dblock, iblock;
	int addr[13];
	static int vbuf[BSIZEW];

        dblock = (ip->di_size-1)/BSIZE + 1;
        iblock = 0;
	l3tol(addr, ip->di_addr, 13);
	if (addr[10])                   /* indirect blocks */
		iblock++;
	if (addr[11]) {                 /* double indirect blocks */
		bread(addr[11], vbuf, sizeof(vbuf));
		for (i = 0; i < BSIZEW; i++)
			if (vbuf[i])
				iblock++;
	}
	/* no triple indirect blocks on our system */
        return(dblock + iblock);
}
 

bread(bno, buf, size)
{
        int n;
        extern errno;
 
        seek(fi, bno << BSHIFT, 0);
        if((n = read(fi, buf, size)) != size) {
                printf("read error bno = %d\n", bno);
                printf("count = %d; errno = %d\n", n, errno);
                exit(1);
        }
}


output()
{
        int i, total, userid;

        total  = 0;
        userid = geteuid();
        for (i=0; i<MAXUSERS; i++) {
		if (!dflg) {
	                if (blocks[i] > 0 && (aflg || i==userid))
	                        printf("%d\t%s\n", blocks[i], username(i));
		} else
		        if (blocks[i] > 0)
			        sumdept(i);
                total =+ blocks[i];
        }
	if (dflg) {
		for (i=0; i<MAXDEPTS; i++)
			if (dept[i] > 0)
				printf("%d\tDept%04d\n", dept[i], i);
	}
        if(!tflg) return;
        printf("\nTotals:\n");
        printf("\tUser   = %d\n", total);
        printf("\tSystem = %d\n", totinod + 2);
        printf("\tFree   = %d\n", totblks - total - totinod - 2);
}

username(uid)
{
	struct passwd *pw;

        if ((pw = getpwuid(uid)) == 0)
		return("?");
        return(pw->pw_name);
}


sumdept(uid)
{
	int i;
	struct passwd *pw;

        if ((pw = getpwuid(uid)) == 0)
		return;
	i = atoi(pw->pw_dept);
        dept[i] += blocks[uid];
}
