#
/*
 * getty -- adapt to terminal speed on dialup, and call login
 */

#include <stdio.h>
#include <sgtty.h>
#include <signal.h>
#define KILL    '@'
#define ERASE   '#'
#define TIMEOUT 180             /* give up after 3 minutes */
#define local   static

local struct sgttyb tmode;
local struct tchars tchars = { '\021', '\034', '\023', '\023', '\004', '\377' };

local struct	tab {
	char	tname;		/* this table name */
	char	nname;		/* successor table name */
	int	iflags;		/* initial flags */
	int	fflags;		/* final flags */
	int	ispeed;		/* input speed */
	int	ospeed;		/* output speed */
	char    kill;           /* kill character */
	char    erase;          /* erase character */
	char	*message;	/* login message */
} itab[] = {

        /* table '0' -  ascii terminal */
        '0', '0',
        CRMOD+XTABS, CRMOD+XTABS,
        B300, B300,
        KILL, ERASE,
        "\n\r;Name: ",
 
        /* table '1' - 3270 */
        '1', '1',
        ECHO+CRMOD, ECHO+CRMOD+IDBL+ODBL+OGRAVE+IGRAVE,
        B9600, B9600,
        0, 0,
        "\n\rName: ",
 
        /* table 'Z' - console */
        'Z', 'Z',
        0, IDBL+ODBL+XTABS+OGRAVE+IGRAVE,
        B300, B300,
        0, 0,
        "\nName: ",

};

#define	NITAB	sizeof itab/sizeof itab[0]
#define	EOT	04		/* EOT char */
#define LOGIN(name) login(name)
/* formerly: execl("/bin/login", "login", name, 0) */

local char	name[16];
local int     crmod;
local int     upper;
local int     lower;

local struct setpf {
	int     pfn;
	char    *pfk;
} setpf;

int hangup();

getty(tname)
{
	register struct tab *tabp;

	if(tname == '1') {     /* reset 3270 PF keys */
		setpf.pfn = 0;
		setpf.pfk = "\004";
		ioctl(0, TUBSETPF, &setpf);
		for(setpf.pfn = 1; setpf.pfn <= 12; setpf.pfn++) {
			switch (setpf.pfn) {
			case 10:
			        setpf.pfk = (char *) 0;    /* Redisplay backward. */
				break;
			case 11:
			        setpf.pfk = (char *) -1;   /* Redisplay foreward. */
				break;
			default:
			        setpf.pfk = "";            /* Nothing. */
				break;
			}
			ioctl(0, TUBSETPF, &setpf);
		}
	}
	for (;;) {
		for(tabp = itab; tabp < &itab[NITAB]; tabp++)
			if(tabp->tname == tname)
				break;
		if(tabp >= &itab[NITAB])
			tabp = itab;
		tmode.sg_flags = tabp->iflags;
		tmode.sg_ispeed = tabp->ispeed;
		tmode.sg_ospeed = tabp->ospeed;
		ioctl(0, TIOCSETP, &tmode);
		ioctl(0, TIOCSETC, &tchars);
		printf("%s", tabp->message);
		signal(SIGALRM, hangup);
		alarm(TIMEOUT);
		if(getname(tabp)) {
			alarm(0);
			tmode.sg_erase = tabp->erase;
			tmode.sg_kill = tabp->kill;
			tmode.sg_flags = tabp->fflags;
			if(crmod)
				tmode.sg_flags |= CRMOD;
			if(upper)
				tmode.sg_flags |= LCASE;
			if(lower)
				tmode.sg_flags &= ~LCASE;
			ioctl(0, TIOCSETN, &tmode);
			if(crmod)
			        putchar('\n');
			LOGIN(name);
			exit(1);
		}
		alarm(0);
		tname = tabp->nname;
	}
}

local getname(tabp)
struct tab *tabp;
{
	register char *np;
	register c;

	crmod = 0;
	upper = 0;
	lower = 0;
	np = name;
	for (;;) {
		if((c = getchar()) == EOF || (c &= 0177) == 0 || c == EOT)
			hangup();
		if (c=='\r' || c=='\n' || np >= &name[16])
			break;
		if (c>='a' && c <='z')
			lower++;
		else if (c>='A' && c<='Z') {
			upper++;
			c += 'a'-'A';
		} else if (c==tabp->erase) {
			if (np > name)
				np--;
			continue;
		} else if (c==tabp->kill) {
			putchar('\r');
			putchar('\n');
			np = name;
			continue;
		} else if(c == ' ')
			c = '_';
		*np++ = c;
	}
	*np = 0;
	if (c == '\r')
		crmod++;
	return(1);
}

local hangup()
{
	tmode.sg_ospeed = 0;
	ioctl(0, TIOCSETP, &tmode);
	exit(1);
}
