/*
 * Update the file system every 30 seconds.
 * For cache benefit, open certain system directories.
 */

#include <signal.h>

char *fillst[] = {
	"/bin",
	"/dev",
	"/etc",
	0,
};

main()
{
	char **f;

	if(fork())
		exit(0);
	signal(SIGHUP, SIG_IGN);
	signal(SIGINTR, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	close(0);
	close(1);
	close(2);
	for(f = fillst; *f; f++)
		open(*f, 0);
	dosync();
	for(;;)
		pause();
}

dosync()
{
	sync();
	signal(SIGALRM, dosync);
	alarm(30);
}
