#include <stdio.h>
#include "dcalc.h"

#define TMPLAB '$'		/* what temporary labels begin with */

int     peekc;
int     tabflg;
int     labno   1;
FILE	*in, *out, *cur, *tmp;
char	outbuf[BUFSIZ];

main(argc, argv)
char **argv;
{
/*
	A1 -> A
	A2    B
	A     O
	B1    C
	B2    D
	BF    P
	C1    E
	C2    F
	F     G
	H     H
	R     I
	R1    J
	S     K
	I     M
	M     N
	Q1    Q
	Q2    L
	ZW    Z
	ZS    N
	ZB    |

		*       +1
		S       +2
		C       +4
		1       +8

	z  -> 4
	c     10
	a     14
	e     20
	n     63
	*       +0100
*/

	int c, snlflg, nlflg, t, smode, m, ssmode;

	smode = nlflg = snlflg = ssmode = 0;
	in = stdin;
	out = stdout;
	if (argc>1)
		if ((in = fopen(argv[1], "r")) == NULL) {
			printf("? %s\n", argv[1]);
			exit(1);
		}
	if (argc>2)
		if ((out = fopen(argv[2], "w")) == NULL) {
			printf("? %s\n", argv[2]);
			exit(1);
		}
	setbuf(out, outbuf);
	if ((tmp = fopen("cvopt.tmp", "w")) == NULL) {
		printf("cvopt.tmp?\n");
		exit(1);
	}
	cur = tmp;
loop:
	c = getch();
	if (c!='\n' && c!='\t')
		nlflg = 0;
	if (ssmode!=0 && c!='%') {
		ssmode = 0;
		cur = out;
		fprintf(cur, "%c%d:\n\tdc c'", TMPLAB, labno++);
	}
	switch(c) {

	case EOF:
	case '\0':
		cur = tmp;
		fprintf(cur, "\tdc a(0)\n");
		cur = out;
		fprintf(cur, "cnop 0,8\n");
		fclose(tmp);
		if ((in = fopen("cvopt.tmp", "r")) == NULL) {
			printf("?tmp\n");
			exit(1);
		}
		while ((c = getc(in)) > 0)
			putc(c, out);
		unlink("cvopt.tmp");
		exit(0);

	case ':':
		if (!smode)
			fprintf(cur, "=.+4; dc f'0'");
		else
			putchr(':');
		goto loop;

	case 'A':
		if ((c=getch())=='1' || c=='2') {
			putchr(c+'A'-'1');
			goto loop;
		}
		putchr('O');
		peekc = c;
		goto loop;

	case 'B':
		switch (getch()) {

		case '1':
                        putchr('C');
			goto loop;

		case '2':
			putchr('D');
			goto loop;

		case 'F':
			putchr('P');
			goto loop;

		case 'H':
			putchr('W');
			goto loop;
		}
		putchr('?');
		goto loop;

	case 'Z':
		switch (getch()) {

		case 'W':
                        putchr('Z');
			goto loop;

		case 'S':
			putchr('N');
			goto loop;

		case 'B':
			putchr('|');
			goto loop;
		}
		putchr('?');
		goto loop;

        case 'C':
		putchr(getch()+'E'-'1');
		goto loop;

	case 'F':
		if ((c = getch()) == 'R') {
			putchr('Y');
			goto loop;
		}
		else {
			putchr('G');
			peekc = c;
			goto subtre;
		}

	case 'Q':
		switch (getch()) {

		case '1':
                        putchr('Q');
			goto loop;

		case '2':
			putchr('L');
			goto loop;
		case 'H':
			putchr('@');
			goto loop;
		}
		putchr('?');
		goto loop;

	case 'R':
		if ((c=getch()) == '1')
		putchr('J'); else {
			putchr('I');
			peekc = c;
		}
		goto loop;

	case 'H':
		if ((c=getch()) == 'X') {
			putchr(getch()+'y'-'1');
			goto loop;
		}
		else {
			peekc = c;
		        putchr('H');
		        goto subtre;
		}

	case 'I':
		putchr('M');
		goto loop;

	case 'S':
		putchr('K');
subtre:
		snlflg = 1;
		t = 'A';
l1:
		switch (c=getch()) {

		case '*':
			t++;
			goto l1;

		case 'S':
			t =+ 2;
			goto l1;

                case 'C':
			t =+ 4;
			goto l1;

		case '1':
			t =+ 8;
			goto l1;

		case '2':
			t =+ 16;
			goto l1;
		}
		peekc = c;
		putchr(t);
		goto loop;

	case '#':
		if(getch()=='1')
			putchr('#'); else
			putchr('"');
		goto loop;

	case '%':
		if (smode)
			cur = tmp;
		if (ssmode==0) {
			if ((peekc=getch())=='[') {
				peekc = 0;
				cur = out;
				while((c=getch())!=']')
					putchr(c);
				getch();
				fprintf(cur, ";");
				cur = tmp;
				goto loop;
			}
		}
loop1:
		switch (c=getch()) {

		case ' ':
		case '\t':
			goto loop1;
		case 'a':
			m = DADDR;
			t = flag();
			goto pf;

		case ',':
			putchr(';');
			goto loop1;

		case 'i':
			m = DINT;
			t = flag();
			goto pf;
		case 'z':
			m = DZERO;
			t = flag();
			goto pf;

		case 'r':
			m = DREG;
			t = flag();
			goto pf;

		case '1':
			m = DCON1;
			t = flag();
			goto pf;

		case 'c':
			t = 0;
			m = DCON;
			goto pf;

		case 'q':
			t = flag();
			m = DLON;
			goto pf;

		case 'e':
			t = flag();
			m = DEASY;
			goto pf;

		case 'n':
			t = flag();
			m = DANY;
pf:
			if ((c=getch())=='*')
				m =+ 0100; else
				peekc = c;
			fprintf(cur, "\tdc x'%2x%2x'", m, t);
			goto loop1;
		case '[':
			fprintf(cur, "%c%d = ", TMPLAB, labno++);
			while ((c=getch())!=']')
				putchr(c);
			ssmode = 0;
			smode = 0;
			goto loop;

		case '\n':
			fprintf(cur, "\n\tdc a(%c%d)\n", TMPLAB, labno);
			ssmode = 1;
			nlflg = 1;
			smode = 1;
			goto loop;
		}
		putchr(c);
		goto loop1;

	case '\t':
		if (nlflg) {
			nlflg = 0;
			goto loop;
		}
		if (smode) {
			tabflg++;
			goto loop;
		}
		putchr('\t');
		goto loop;

	case '\n':
		while ((c = getch()) == '/'){
			while ((c = getch()) != '\n');
			}
		peekc = c;
		if (!smode)  {
			putchr('\n');
			goto loop;
		}
		if (nlflg) {
			nlflg = 0;
			fprintf(cur, "\\0'\n");
			cur = tmp;
			smode = 0;
			goto loop;
		}
		if (!snlflg)
			fprintf(cur, "\\n");
		snlflg = 0;
		fprintf(cur, "'\n\tdc c'");
		nlflg = 1;
		goto loop;

	case 'X':
	case 'Y':
		snlflg++;

	case 'T':
	;
	}
	if (cur == out && c == '\''){
		putchr('\\');
		putchr('q');
		}
	else putchr(c);
	goto loop;
}

getch() {
	register t;

	if (peekc) {
		t = peekc;
		peekc = 0;
		return(t);
	}
	return(getc(in));
}

flag() {
	register c, f;

	f = 0;
l1:
	/*
	 * Note that the value returned for 'i', 'b', 'f', 'd', 's', 'l',
	 * 'u', 't', and 'v' is 2 greater than the corresponding data type value
	 * (i.e. INT, CHAR, FLOAT, DOUBLE, SHORT, LONG, UNSIGNED, UNSHRT, and UNLNG)
	 */
	switch(c=getch()) {

	case 'w':
		f = 1;
		goto l1;

	case 'i':
		f = 2;
		goto l1;

	case 'b':
		f = 3;
		goto l1;

	case 'f':
		f = 4;
		goto l1;

	case 'd':
		f = 5;
		goto l1;

	case 's':
		f = 7;
		goto l1;

	case 'l':
		f = 8;
		goto l1;

	case 'u':
		f = 9;
		goto l1;

	case 't':
		f = 11;
		goto l1;

	case 'p':
		f =+ 16;
		goto l1;
	case 'v':
		f =+ 12;
		goto l1;
	}
	peekc = c;
	return(f);
}

putchr(c)
{
	if (tabflg) {
		tabflg = 0;
		fprintf(cur, "'; dc x'%2x'; dc c'", c+0200);
	} else
		putc(c, cur);
}
