/*
 * manifest constants
 *  the following attempt to take into account things like
 *  system blocksize, the word length on the machine running UNIX
 *  and the resultant change in some of the structures.  Quite beneficial
 *  when used in conjunction with "sizeof" in the c compiler for attempting
 *  fairly machine independent code...
 */
#define BLKSIZE         512
#define BLKSIZEW        (BLKSIZE/4)     /* blocksize in words */
#define DIRENTSZ        16              /* total bytes in directory entry */
#define WORDSIZE        4               /* four byte words */

/*
 * fundamental constants
 * cannot be changed
 */

#define USIZE   1               /* size of user struct in pages */
#define NULL    0
#define NODEV   (-1)
#define ROOTINO 1               /* i number of all roots */
#define DIRSIZ  14              /* max characters per directory */

/*
 * structure to access an
 * integer in bytes
 */
struct
{
        char    fil1byte;
        char    fil2byte;
        char    hibyte;
        char    lobyte;
};

/*
 * structure to access an integer
 */
struct
{
        int     integ;
};
