#include <stdio.h>

char *sys_siglist[] = {
	"no signal 0",
	"hangup (help sig.1)",
	"interrupt (help sig.2)",
	"quit (help sig.3)",
	"operation exception (help sig.4)",
	"monitor call (help sig.5)",
	"program event (help sig.6)",
	"page translation exception (help sig.7)",
	"floating divide exception (help sig.8)",
	"killed (help sig.9)",
	"specification exception (help sig.10)",
	"segmentation exception (help sig.11)",
	"bad system call (help sig.12)",
	"broken pipe (help sig.13)",
	"alarm clock (help sig.14)",
	"terminated (help sig.15)",
	"privileged operation exception (help sig.16)",
	"execute exception (help sig.17)",
	"protection exception (help sig.18)",
	"data exception (help sig.19)",
	"fixed point overflow exception (help sig.20)",
	"fixed point divide exception (help sig.21)",
	"decimal overflow exception (help sig.22)",
	"decimal divide exception (help sig.23)",
	"exponent overflow exception (help sig.24)",
	"exponent underflow exception (help sig.25)",
	"significance exception (help sig.26)",
	"out of disk space (help sig.27)",
	"out of system file structures (help sig.28)",
	"program initiation (help sig.29)",
	"SVC interrupt (help sig.30)",
	"time slice end (help sig.31)",
	0,
};

int sys_nsig = sizeof sys_siglist / sizeof(char *);

/*
 * Print a signal message
 */
psignal(s, n)
char *s;
{
	n &= 0177;      /* get rid of excess from wait status */
	fprintf(stderr, "%s: ", s);
	if(n < sys_nsig)
		fprintf(stderr, "%s\n", sys_siglist[n]);
	else if(n == 0177)
		fprintf(stderr, "stopped for tracing\n");
	else
		fprintf(stderr, "signal %d\n", n);
}
