#include "../h/io.h"
#include "../h/ios.h"
#include "../h/370.h"

/*
 * I/O initialization
 */
ioinit()
{
        int i, cc;
 
        for(i=0;i<NCHANS;i++) {
                if(chans[i]) {
                        cc = a_stidc(i<<8);
                        if(cc == 0) {
                                chans[i]->ch_type = CHANID >> 28;
                                chans[i]->ch_state = FREE;
                        } else { /* vm: assume BMX for new channels */
                                chans[i]->ch_type = BMX;
                                chans[i]->ch_state = FREE;
                        }
                }
        }
        ioqinit();
        coninit();
}
 
/*
 * Queue SIO request.
 */
sio(addr, caw, intr, arg)
int addr, (*intr)(), arg;
ccw_t *caw;
{
        struct chan *ch;
        struct cu   *cu;
        struct unit *un;
        struct ioq  *q;
 
        if (iolkup(addr, &ch, &cu, &un)) {
		printf("sio: no device %x\n", addr);
                ipanic("no device\n");
	}
	if (caw == 0) {
		printf("sio: zero caw. devaddr %x\n", addr);
		panic("sio: zero caw.");
	}
        q = getq();
        q->io_type = SIO;
        q->io_caw = (USERKEY << 28) | (int)caw;
        q->io_devaddr = addr;
        q->io_intr = intr;
        q->io_arg = arg;
        ioenq(q, &un->un_q);
        iostart(iodeq(&un->un_q));
}
 
/*
 * Queue a TIO request.
 */
tio(addr, intr, arg)
int addr, (*intr)(), arg;
{
        struct chan *ch;
        struct cu   *cu;
        struct unit *un;
        struct ioq  *q;
 
        if(iolkup(addr, &ch, &cu, &un)) {
		printf("tio: no device %x\n", addr);
                ipanic("no device\n");
	}
        q = getq();
        q->io_type = TIO;
        q->io_devaddr = addr;
        q->io_intr = intr;
        q->io_arg = arg;
        ioenq(q, &un->un_q);
        iostart(iodeq(&un->un_q));
}
 
/*
 * Queue a HIO request.
 */
hio(addr)
int addr;
{
        struct chan *ch;
        struct cu   *cu;
        struct unit *un;
        struct ioq  *q;
 
        if(iolkup(addr, &ch, &cu, &un)) {
		printf("hio: no device %x\n", addr);
                ipanic("no device\n");
	}
        q = getq();
        q->io_type = HIO;
        q->io_devaddr = addr;
        q->io_intr = 0;
        ioenq(q, &un->un_q);
        iostart(iodeq(&un->un_q));
}
 
/*
 * Set an asynchronous interrupt exit.
 */
setax(addr, intr, arg)
int addr, (*intr)(), arg;
{
        struct chan *ch;
        struct cu   *cu;
        struct unit *un;
 
        if(iolkup(addr, &ch, &cu, &un)) return(-1);
        un->un_intr = intr;
        un->un_arg = arg;
        return(0);
}
 
/*
 * Return current asynchronous exit values.
 * This is so caller can stack exits.
 *
 * Currently not used
 */
/*
getax(addr, intr, arg)
int addr, (**intr)(), *arg;
{
        struct chan *ch;
        struct cu   *cu;
        struct unit *un;
 
        if(iolkup(addr, &ch, &cu, &un)) return(-1);
        *intr = un->un_intr;
        *arg = un->un_arg;
        return(0);
}
*/
 
iolkup(addr, ch, cu, un)
int addr;
struct chan **ch;
struct cu   **cu;
struct unit **un;
{
        int chn, cun, unn;
 
        chn = (addr >> 8) &037;
        if(chn >= NCHANS || chans[chn] == 0)
                return(1);
        cun = (addr >> 4) & 017;
        if(chans[chn]->ch_cu[cun] == 0)
                return(2);
        unn = addr & 017;
        if(chans[chn]->ch_cu[cun]->cu_un[unn] == 0)
                return(3);
        *ch = chans[chn];
        *cu = (*ch)->ch_cu[cun];
        *un = (*cu)->cu_un[unn];
        return(0);
}
 
/*
 * Start any queued requests on the specified channel,
 * control unit, and unit.
 */
qstart(ch, cu, un)
struct chan *ch;
struct cu   *cu;
struct unit *un;
{
        if(ch->ch_state != FREE)
                return;
        if(ch->ch_q)
                iostart(iodeq(&ch->ch_q));
        if(cu->cu_state != FREE)
                return;
        if(cu->cu_q)
                iostart(iodeq(&cu->cu_q));
        if(un->un_q) {
                if(un->un_state != FREE && un->un_q->io_type == SIO) return;
                iostart(iodeq(&un->un_q));
        }
}
 
/*
 * Start an I/O request.
 */
iostart(q)
struct ioq *q;
{
        struct chan *ch;
        struct cu   *cu;
        struct unit *un;
	csw_t csw;
        int cc;
 
        iolkup(q->io_devaddr, &ch, &cu, &un);
        if(un->un_state == WORKING && q->io_type == SIO) {
                ioenq(q, &un->un_q);
                qstart(ch, cu, un);
                return;
        }
        if(cu->cu_state == WORKING) {
                ioenq(q, &cu->cu_q);
                qstart(ch, cu, un);
                return;
        }
        if(ch->ch_state == WORKING) {
                ioenq(q, &ch->ch_q);
        /*      qstart(ch, cu, un);     pointless */
                return;
        }
 
        switch(q->io_type) {
 
        case SIO:
                cc = a_siof(q->io_devaddr, q->io_caw);
		if (cc)
			break;
                un->un_state = WORKING;
                if(ch->ch_type == SELECTOR) ch->ch_state = WORKING;
                un->un_actv = q;
		q->io_mint = un->un_mint;
                break;
 
        case TIO:
                cc = a_tio(q->io_devaddr);
		if (cc)
			break;
                un->un_state = FREE;
                un->un_csw.cs_dblw = 0L;
                (*q->io_intr)(q->io_arg, &un->un_csw, un->un_sense);
                freeq(q);
                break;
 
        case HIO:
                cc = a_hdv(q->io_devaddr);
		if (cc)
			break;
                if (ch->ch_type == SELECTOR) {
                        ch->ch_state = WORKING;
                        ioenq(q, &ch->ch_q);
                } else {
                        /*
			 * When hdv gives condition code 0 on a
                         * multiplexor channel, either the subchannel
			 * is busy with another device, or it contains
			 * a pending interrupt.  In the first case we
                         * want to queue the hdv at the control unit,
			 * and in the second case we are willing to
			 * take the interrupt.  Clrio to the device
                         * will give cc 0 or 2 in the first case,
                         * cc 1 in the second.
                         */
                        cc = a_clrio(q->io_devaddr);
                        switch (cc) {
                        case 0:
                                ioenq(q, &cu->cu_q);
                                break;
                        case 1:
                                IOADDR = q->io_devaddr;
                                iointr();
				cc = 0;  /* to avoid common cc handling */
                                break;
                        }
		}
                break;

	case CLR_HDV:
		cc = a_hdv(q->io_devaddr);
		csw = CSW;
		printf("Missing interrupt - hdv. cc %d\n", cc);
		deverr(q->io_devaddr, csw);
		if (cc > 1 || (cc == 1 && csw.cs_sm && csw.cs_busy))
			break;
		if (cc == 1)
			q->io_type = CLR_CLRIO;
		/* Fall through rather than call iostart again. */

	case CLR_CLRIO:
		cc = a_clrio(q->io_devaddr);
		csw = CSW;
		printf("Missing interrupt - clrio. cc %d\n", cc);
		deverr(q->io_devaddr, csw);
		if (cc > 1)
			break;
		if (cc == 0 && q->io_type == CLR_HDV) /* See comment above concerning hdv, clrio. */
			ioenq(q, &cu->cu_q);
		else {        /* Finally tell driver about missing interrupt. */
                        un->un_csw.cs_dblw = 0L;
                        (*q->io_intr)(q->io_arg, &un->un_csw, un->un_sense);
                        freeq(q);
			un->un_state = FREE;
                        cc = 0;  /* Avoid common cc handling. */
		}
		break;
        }

	/*
	 * Common condition code handling.
	 */
        switch(cc) {
 
        case 1:
                iocc1(q, ch, cu, un);
                break;
 
        case 2:
                ch->ch_state = WORKING;
                ioenq(q, &ch->ch_q);
                if(q->io_type == HIO)
			a_tch(q->io_devaddr);  /* prime for CAI */
                break;
 
        case 3:
                iocc3(q, ch, cu, un);
                break;
        }
        qstart(ch, cu, un);
}
