/*
 * header file for debugger
 */

#define NULL 0
#define NAMESIZE 8
#define SYMSIZ 4000
#define INFINITY 999999
#define MEMTEST  6291456  /* 6 megabyte real memory, prevent prog ints */
#define MAXNARGS 20
#define PROLOG 18 /* ??? apt */ /* bytes compiled func. begins after prolog */
#define READ 0
#define WRITE 1
#define PRINST (prtmode=='i' || prtmode=='j')

/*
 * implementation dependencies
 */

#define bPB 8
#define bPW 32
#define BPW 4
#define BPL 8
#define BPHW 2
#define CORESTART 4096		/* really size of user structure */
#define PAGESIZE 4096
#define STACKTOP 0xffffff
#define AOUTSTART 8*BPW
#define SEGSIZE 0x10000		/* text-shared round up boundary */
#define MAGIC 0x47f00020
#define SHRMAGIC 0x47f00024
#define EXTERN 0100
#define LOCAL 037
#define TEXT 2
#define DATA 3
#define BSS 4
#define ILC ((state.ps_pgm >> 16)&017)		/* instruction length */

/*
 * storage classes
 */

#define GLOBL 0
#define AUTO 1
#define REGVAR 2
#define MOS 3
#define FUNC 4

/*
 * data structures
 */

struct symtab {
	char name[8];
	int type;
	int val;
	};

struct bp {
	int bp_addr;
	short int bp_val;
	struct tnode *bp_cmd;
	char bp_comment[80];
	struct bp *bp_next;
	int bp_count;
	} ;
extern struct bp brkpts[];

/* struct _iobuf {
 *                char *_ptr;
 *                int _cnt;
 *                char *_base;
 *                int _flag;
 *                int _file;
 *              } ;
 */

/* struct longint {
 *        int high;
 *        int low;
 *        };
 */

struct optab {
          int op_val;
          char *op_name;
          int op_type;
          };


/* struct systab {
 *        int sys_svcno;
 *        char *sys_name;
 *        };
 */

struct tnode {
	int t_op;
	int t_val;
	struct tnode *t_left;
	struct tnode *t_right;
	} ;
extern struct tnode tree[];
extern short int freelist[];
extern int tnodelist[];
extern int tnodecnt;
extern int specialflg;
extern short int brlist[];
extern int *gpr_ptr ;             /* pointer to Au's registers   */
extern int *creg_ptr ;            /* pointer to Au's registers   */
extern int *psw_ptr ;             /* pointer to psw that came in     */
extern int *csw_ptr ;             /* pointer to csw                  */
extern int *caw_ptr ;             /* pointer to caw                  */
extern struct symtab *symbols ;   /* pointer to start of symbol table   */
extern struct symtab *symbole ;   /* pointer to start of symbol table   */
extern struct symtab symtbl[];    /* the symbol table                */
extern char aptout[] ;            /* string for output routine       */
extern char tmpchr[] ;            /* string for comments             */
extern char multcomm[] ;          /* string for multiple commands    */
extern char blankchr[];           /* dummy character for a kludge    */
extern int aptnum;                /* decimal eauivalent of input number */
extern int pa1key;                /* flag telling if pa1key has been hit*/

/*
 * 470 opcode structure
 */

struct op470 {
	int opcode : 8;
	int r1 : 4;
	int r2 : 4;
	int base1 : 4;
	int disp1 : 12;
	};

struct sop {
	int sopcode : 16;
	};

struct ssopend {
	int base2 : 4;
	int disp2 : 12;
	};

typedef struct symtab SYM;
typedef struct bp BP;

extern int dot;
extern int dotdot;
extern int lastbp;
extern int yylval;
extern int xlate;
extern int prtlen;
extern int savplen;
extern int prtmode;
extern int instlen;
/* extern struct symtab *hashp[];
 * extern struct symtab *valp[];
 */
extern BP *bptail;
struct optab *oplookup(), *brlookup();

/*
 * instruction decoding stuff
 */

#define NUMOPS 183
#define NUMSYS 47
#define NUMBRS 30

#define RR 1
#define RX 2
#define RS1 3
#define RS2 4
#define S 5
#define SI1 6
#define SI2 7
#define SS1 8
#define SS2 9
#define SS3 10
#define BRANCH 11
#define BRANCHR 12
#define LPSW 13
#define BRCNTR 14
#define BRCNT 15
 
/*
 * some opcodes
 */
 
#define BC 0x47
#define BCR 0x07
#define SVC 0x0a
#define SPM 0x04
#define BALR 0x05
#define BAL 0x45


