#
/*
 * Random set of variables
 * used by more than one
 * routine.
 */
int	*rootdir;		/* pointer to inode of root directory */
int	rootdev;		/* designation of the root device (conf/c.c) */
int	time[2];		/* time in sec from 1970 */
int	tout[2];		/* time of day of next sleep */
char	scratchpage[512];	/* used by exec to store parameters */
char	*panicstr;		/* last panic string printed out */
int	*super_d_space;		/* pointer to the array of capabilities
				   for the supervisor d space segments */



/*
 * The callout structure is for
 * a routine arranging
 * to be called by the clock interrupt
 * (clock.c) with a specified argument,
 * in a specified amount of time.
 * Used, for example, to time tab
 * delays on teletypes.
 */
struct	callo
{
	int	c_time;		/* incremental time */
	int	c_arg;		/* argument to routine */
	int	(*c_func)();	/* routine */
} callout[NCALL];



/*
 * Mount structure.
 * One allocated on every mount.
 * Each entry is paired with a reserved superblock in core.
 */
struct	mount
{
	int	m_dev;		/* designation of device mounted */
	int	m_inuse;	/* whether or not this entry is inuse */
	int	*m_inodp;	/* pointer to "mounted on" inode */
} mount[NMOUNT];

char superblocks[NMOUNT][512];
