/ PDP- 8 simulator

	jmp	init
init1:
	clr	-(r2)
	cmp	r2,$mem
	bhi	init1
	br	loop

incloop:
	inc	r5
	bic	$!7777,r5
loop:
	tstb	pieflg
	beq	1f
	inc	kdelay
	bne	2f
	bis	$4,active
	inc	kdelay
2:
	tst	active
	beq	1f
	incb	delay
	blt	1f
	comb	pieflg
	clr	r1
	mov	r5,r0
	jsr	pc,store
	mov	$1,r5
1:
	mov	r5,r1
	jsr	pc,fetch
	mov	r0,r2
	tstb	trace
	beq	1f
	jsr	pc,print
1:
	bic	$777,r0
	swab	r0
	jmp	*1f(r0)
1:
	op0; op1; op2; op3; op4; op5; op6; op7

/ and
op0:
	jsr	pc,addr
	jsr	pc,fetch
	com	r0
	bic	r0,r4
	br	incloop

/ tad
op1:
	jsr	pc,addr
	jsr	pc,fetch
	add	r0,r4
	bit	$10000,r4
	beq	incloop
	bic	$!7777,r4
	comb	lnk
	br	incloop

/ isz
op2:
	jsr	pc,addr
	jsr	pc,fetch
	inc	r0
	jsr	pc,store
	tst	r0
	bne	incloop
	inc	r5
	br	incloop

/ dca
op3:
	jsr	pc,addr
	mov	r4,r0
	jsr	pc,store
	clr	r4
	br	incloop

/ jms
op4:
	jsr	pc,addr
	mov	r5,r0
	inc	r0
	jsr	pc,store
	mov	r1,r5
	br	incloop

/ jmp
op5:
	jsr	pc,addr
	mov	r1,r5
	br	loop

op6:
	mov	r2,r0
	asr	r0
	asr	r0
	bic	$!176,r0
	cmp	r0,$4*2
	blos	1f
	cmp	r2,$6101
	bne	2f
	inc	r5
2:
	br	incloop
1:
	mov	r0,-(sp)
	bit	$1,r2
	beq	1f
	jsr	pc,*iot1(r0)
	mov	(sp),r0
1:
	bit	$2,r2
	beq	1f
	jsr	pc,*iot2(r0)
	mov	(sp),r0
1:
	bit	$4,r2
	beq	1f
	jsr	pc,*iot4(r0)
1:
	tst	(sp)+
	jmp	incloop

iot1:
	iot01
	iot11
	iot21
	iot31
	iot41
iot2:
	iot02
	iot12
	iot22
	iot32
	iot42
iot4:
	iot04
	iot14
	iot24
	iot34
	iot44

op7:
	mov	$oprtab,r1
1:
	mov	(r1)+,r0
	beq	1f
	bit	r0,r2
	bne	2f
	tst	(r1)+
	br	1b
2:
	jsr	pc,*(r1)+
	bic	$!7777,r4
	br	1b
1:
	jmp	*(r1)+

oprtab:
	400; group2
	200; clra
	100; clrl
	040; coma
	020; coml
	001; inca
	010; rotar
	004; rotal
	000; incloop

group2:
	mov	$opr2tab,r1
	rts	pc

clra:
	clr	r4
	rts	pc

clrl:
	clrb	lnk
	rts	pc

coma:
	com	r4
	rts	pc

coml:
	comb	lnk
	rts	pc

inca:
	inc	r4
	rts	pc

rotar:
	tstb	lnk
	beq	1f
	bis	$10000,r4
1:
	asr	r4
	clrb	lnk
	bcc	2f
	br	3f

rotal:
	asl	r4
	tstb	lnk
	beq	1f
	inc	r4
1:
	clrb	lnk
	bit	$10000,r4
	beq	2f
3:
	comb	lnk
2:
	bit	$2,r2
	beq	1f
	bic	$2,r2
	sub	$4,r1
1:
	rts	pc

opr2tab:
	001; eaegroup
	100; skpm
	040; skpz
	020; skpn
	010; skipn
	200; clra
	004; orsw
	002; halt
	000; skip

eaegroup:
	mov	$eaetab,r1
	rts	pc

skpm:
	bit	$4000,r4
	bne	1f
	rts	pc

skpz:
	tst	r4
	beq	1f
	rts	pc

skpn:
	tstb	lnk
	bne	1f
	rts	pc
1:
	bisb	$377,skpflg
	rts	pc

skipn:
	comb	skpflg
	rts	pc

orsw:
	bis	csw,r4
	rts	pc

halt:
	cmp	r5,$7700
	bne	1f
	mov	$177,r5
	clrb	skpflg
	rts	pc
1:
	jsr	r5,mesg
		<HALT\n\0>; .even
	jmp	dump

skip:
	tstb	skpflg
	beq	1f
	clrb	skpflg
	inc	r5
1:
	jmp	incloop

eaetab:
	200; clra
	100; mqta
	040; scta
	020; mqfa
	016; eaeop
	000; incloop

mqta:
	bis	mpq,r4
	rts	pc

scta:
	bisb	sct,r4
	rts	pc

mqfa:
	mov	r4,mpq
	clr	r4
	rts	pc

eaeop:
	mov	r2,r0
	bic	$!16,r0
	jmp	*1f-2(r0)
1:
	eae1; eae2; eae3; eae4; eae5; eae6; eae7

/ scl
eae1:

/ muy
eae2:

/ dvi
eae3:

/ nmi
eae4:

/ shl
eae5:

/ asr
eae6:

/ lsr
eae7:
	jsr	r5,mesg
		<EAE\n\0>; .even
	jmp	dump

addr:
	mov	r2,r1
	bic	$!177,r1
	bit	$200,r2			/ page
	beq	1f
	mov	r5,r0
	bic	$177,r0
	add	r0,r1
1:
	bit	$400,r2			/ indirect
	beq	1f
	jsr	pc,fetch
	cmp	r1,$17
	bhi	2f
	cmp	r1,$10
	blo	2f
	inc	r0
	jsr	pc,store
2:
	mov	r0,r1
1:
	rts	pc

fetch:
	asl	r1
	cmp	r1,$6144.
	bhis	1f
	mov	mem(r1),r0
	bic	$!7777,r0
	asr	r1
	rts	pc
1:
	mov	mem-6144.(r1),mq
	mov	$4,lsh
	mov	ac,r0
	mov	mem-4096.(r1),mq
	mov	r0,ac
	mov	$4,lsh
	mov	ac,r0
	mov	mem-2048.(r1),mq
	mov	r0,ac
	mov	$4,lsh
	mov	ac,r0
	bic	$!7777,r0
	asr	r1
	rts	pc

store:
	bic	$!7777,r0
	asl	r1
	cmp	r1,$6144.
	bhis	1f
	bic	$7777,mem(r1)
	bis	r0,mem(r1)
	asr	r1
	rts	pc
1:
	mov	r0,-(sp)
	mov	r0,ac
	mov	$-4,lsh
	mov	mq,r0
	bic	$7777,r0
	bic	$!7777,mem-2048.(r1)
	bis	r0,mem-2048.(r1)
	mov	$-4,lsh
	mov	mq,r0
	bic	$7777,r0
	bic	$!7777,mem-4096.(r1)
	bis	r0,mem-4096.(r1)
	mov	$-4,lsh
	mov	mq,r0
	bic	$7777,r0
	bic	$!7777,mem-6144.(r1)
	bis	r0,mem-6144.(r1)
	asr	r1
	mov	(sp)+,r0
	rts	pc

mesg:
	movb	(r5)+,r0
	beq	1f
	jsr	pc,putc
	br	mesg
1:
	inc	r5
	bic	$1,r5
	rts	r5

dump:
	sys	intr; out
	jsr	pc,print
	clr	r4
	mov	ttybuf+6,ttybuf+4
	beq	1f
	clr	r0
	sys	37; ttybuf
1:
	cmp	r4,$10000
	bhis	out
	mov	r4,r1
	add	$8,r4
2:
	jsr	pc,fetch
	tst	r0
	bne	2f
	inc	r1
	cmp	r1,r4
	blo	2b
	br	1b
2:
	mov	r4,r1
	sub	$8,r1
	mov	r1,r0
	jsr	r5,octal; 40
2:
	jsr	pc,fetch
	inc	r1
	cmp	r1,r4
	bhis	2f
	jsr	r5,octal; 40
	br	2b
2:
	jsr	r5,octal; 12
	br	1b

out:
	mov	ttybuf+6,ttybuf+4
	beq	1f
	clr	r0
	sys	37; ttybuf
	sys	exit

print:
	mov	r0,-(sp)
	mov	r5,r0
	jsr	r5,octal; 40
	mov	r2,r0
	jsr	r5,octal; 40
	mov	$' ,r0
	tstb	lnk
	beq	1f
	movb	$'-,r0
1:
	jsr	pc,putc
	mov	r4,r0
	jsr	r5,octal; 12
	mov	(sp)+,r0
	rts	pc

octal:
	mov	r0,mq
	mov	$4,-(sp)
	mov	(sp),lsh
1:
	clr	ac
	mov	$3,lsh
	mov	ac,r0
	add	$60,r0
	jsr	pc,putc
	dec	(sp)
	bgt	1b
	tst	(sp)+
	mov	(r5)+,r0
	jsr	pc,putc
	rts	r5

putc:
	movb	r0,ch
	mov	$1,r0
	sys	write; ch; 1
	rts	pc

/  ion
iot01:
	bisb	$377,pieflg
	movb	$-5,delay
	rts	pc

/ iof
iot02:
	clrb	pieflg
iot04:
	rts	pc

/ rsf
iot11:
	bit	$1,active
	beq	1f
	inc	r5
1:
	rts	pc

/ rrb
iot12:
	bic	$1,active
	mov	ppti,r0
	sys	read; ch; 1
	bes	1f
	tst	r0
	beq	1f
	bisb	ch,r4
	rts	pc
1:
	jsr	r5,mesg
		<EOF on ppt\n\0>; .even
	jmp	dump

/ rfc
iot14:
	bis	$1,active
	rts	pc

/ psf
iot21:
	bit	$2,active
	beq	1f
	inc	r5
1:
	rts	pc

/ pcf
iot22:
	bic	$2,active
	rts	pc

/ ppc
iot24:
	movb	r4,ch
	mov	ppto,r0
	sys	write; ch; 1
	bis	$2,active
	rts	pc

/ ksf
iot31:
	tst	kdelay
	bne	1f
	bis	$4,active
	inc	r5
	rts	pc
1:
	bit	$4,active
	beq	1f
	inc	r5
1:
	rts	pc

/ kcc
iot32:
	clr	r4
	bic	$4,active
	rts	pc

/ krs
iot34:
	comb	readflg
	mov	ttyi,r0
	sys	read; ch; 1
	bes	1f
	tstb	readflg
	beq	iot34
	clrb	readflg
	tst	r0
	beq	1f
	clr	r0
	bisb	ch,r0
	tst	ttyi
	bne	3f
	cmp	r0,$4
	beq	1f
	cmp	r0,$'a
	blo	2f
	cmp	r0,$'z
	bhi	2f
	sub	$40,r0
2:
	bis	$200,r0
	cmp	r0,$212
	bne	3f
	mov	$215,r0
3:
	bis	r0,r4
	rts	pc
1:
	tst	ttyi
	beq	1f
	clr	ttyi
	clr	r0
	sys	40; ttybuf
	mov	ttybuf+4,ttybuf+6
	bis	$40,ttybuf+4
	bic	$10,ttybuf+4
	clr	r0
	sys	37; ttybuf
	mov	$7776,r5
	rts	pc
1:
	jsr	r5,mesg
		<EOF on tty\n\0>; .even
	jmp	dump

/ tsf
iot41:
	bit	$10,active
	beq	1f
	inc	r5
1:
	rts	pc

/ tcf
iot42:
	bic	$10,active
	rts	pc

/ tpc
iot44:
	movb	r4,ch
	cmpb	r4,$215
	beq	1f
	mov	$1,r0
	sys	write; ch; 1
1:
	bis	$10,active
	rts	pc

tracer:
	comb	trace
	clrb	readflg
	2

readflg:.=.+1
lnk:	.=.+1
skpflg:	.=.+1
ch:	.=.+1
sct:	.=.+1
pieflg:	.=.+1
delay:	.=.+1
trace:	.=.+1
pptflg:	.=.+1
	.even
ttybuf:	.=.+8.
ttyi:	.=.+2
ppti:	.=.+2
ppto:	.=.+2
active:	.=.+2
kdelay:	.=.+2
mpq:	.=.+2
mem:
	6032
	6031
	5357
	6036
	7106
	7006
	7510
	5357
	7006
	6031
	5367
	6034
	7420
	3776
	3376
	5356
	0000
	5000

init:
	sys	intr; tracer
	sys	quit; out

/ copy in abs loader
	mov	$mem,r2
	mov	$7756,r1
	mov	r1,r5
1:
	mov	(r2)+,r0
	jsr	pc,store
	inc	r1
	cmp	r1,$10000
	blo	1b

/ open files
	sys	open; binldr; 0
	bes	error
	mov	r0,ttyi
	sys	open; paperi; 0
	bes	error
	mov	r0,ppti
	sys	creat; papero; 17
	bes	error
	mov	r0,ppto

/ get back to main sequence
	mov	$einit,r2
	jmp	init1

error:
	jsr	r5,mesg
		<Cannot open paper files\n\0>; .even
	sys	exit

paperi:
	<paperi\0>
papero:
	<papero\0>
binldr:
	<binldr\0>
	.even
einit:
	. = mem+6144.

